/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.pircbot;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TrustingSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory factory;
    private String[] ciphers;

    public TrustingSSLSocketFactory() throws SSLException {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        try {
            SSLContext sslContext = SSLContext.getInstance("SSLv3");
            sslContext.init(null, new TrustManager[]{new TrustingX509TrustManager()}, null);
            this.factory = sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SSLException("Unable to initialize the SSL context:  ", nsae);
        }
        catch (KeyManagementException kme) {
            throw new SSLException("Unable to register a trust manager:  ", kme);
        }
        this.ciphers = this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.ciphers;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.ciphers;
    }

    @Override
    public Socket createSocket() throws IOException, UnknownHostException {
        return this.prepare((SSLSocket)this.factory.createSocket());
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.prepare((SSLSocket)this.factory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.prepare((SSLSocket)this.factory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.prepare((SSLSocket)this.factory.createSocket(address, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.prepare((SSLSocket)this.factory.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.prepare((SSLSocket)this.factory.createSocket(s, host, port, autoClose));
    }

    private SSLSocket prepare(SSLSocket baseSocket) {
        baseSocket.setEnabledCipherSuites(this.ciphers);
        return baseSocket;
    }

    private class TrustingX509TrustManager
    implements X509TrustManager {
        private TrustingX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

