/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.pircbot;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.jibble.pircbot.PircBotLogger;

public class FallbackInputStreamReader
extends Reader {
    private static final boolean debug = false;
    private final PircBotLogger logger;
    private final InputStream in;
    private final Charset primaryCharset;
    private final Charset fallbackCharset;
    private boolean gotEof;
    private ByteBuffer buf = ByteBuffer.allocate(1024);
    private int bufFillLevel;
    private byte[] tmp = new byte[1024];
    private CharBuffer decBuf;
    private Charset lastCharset;

    public FallbackInputStreamReader(PircBotLogger logger, InputStream in, String primaryCharsetName, String fallbackCharsetName) throws UnsupportedEncodingException {
        this.logger = logger;
        this.in = in;
        this.primaryCharset = Charset.forName(primaryCharsetName);
        this.fallbackCharset = Charset.forName(fallbackCharsetName);
        this.buf.limit(0);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.fillDecodeBuffer();
        if (this.decBuf == null) {
            return -1;
        }
        int rem = this.decBuf.remaining();
        if (rem < len) {
            len = rem;
        }
        this.decBuf.get(cbuf, off, len);
        return len;
    }

    private void fillDecodeBuffer() throws IOException {
        if (this.decBuf != null && this.decBuf.hasRemaining()) {
            return;
        }
        this.fillBuffer();
        if (this.buf == null) {
            this.decBuf = null;
            return;
        }
        CharsetDecoder d = this.primaryCharset.newDecoder();
        d.onMalformedInput(CodingErrorAction.REPORT);
        d.onUnmappableCharacter(CodingErrorAction.REPORT);
        int origPos = this.buf.position();
        try {
            this.decBuf = d.decode(this.buf);
            this.lastCharset = this.primaryCharset;
        }
        catch (IOException e) {
            d = this.fallbackCharset.newDecoder();
            d.onMalformedInput(CodingErrorAction.REPLACE);
            d.onUnmappableCharacter(CodingErrorAction.REPLACE);
            try {
                this.buf.position(origPos);
                this.decBuf = d.decode(this.buf);
                this.lastCharset = this.fallbackCharset;
            }
            catch (CharacterCodingException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private void fillBuffer() throws IOException {
        if (this.gotEof) {
            if (this.buf != null && !this.buf.hasRemaining()) {
                this.buf = null;
            }
            return;
        }
        if (this.buf != null && this.buf.hasRemaining()) {
            this.logger.log("### BUG in FISR: pos<lim: " + this.buf.position() + " < " + this.buf.limit());
            this.buf.position(this.buf.limit());
        }
        this.buf.limit(this.bufFillLevel);
        this.buf.compact();
        this.bufFillLevel = this.buf.position();
        if (this.checkLF(0)) {
            return;
        }
        try {
            int start;
            do {
                int r;
                if ((r = this.in.read(this.tmp)) == -1) {
                    this.gotEof = true;
                    this.tmp = null;
                    this.buf.flip();
                    if (this.buf.remaining() == 0) {
                        this.buf = null;
                    }
                    return;
                }
                if (this.buf.remaining() < r) {
                    this.buf.flip();
                    ByteBuffer bb = ByteBuffer.allocate(this.buf.capacity() * 2);
                    bb.put(this.buf);
                    this.buf = bb;
                }
                start = this.buf.position();
                this.buf.put(this.tmp, 0, r);
                this.bufFillLevel = this.buf.position();
            } while (!this.checkLF(start));
            return;
        }
        catch (IOException e) {
            this.buf.limit(0);
            throw e;
        }
    }

    private boolean checkLF(int start) {
        for (int i = start; i < this.buf.position(); ++i) {
            if (this.buf.get(i) != 10) continue;
            this.buf.position(0);
            this.buf.limit(i + 1);
            return true;
        }
        return false;
    }
}

