/*
 * Decompiled with CFR 0.152.
 */
package com.ensifera.animosity.craftirc;

import com.ensifera.animosity.craftirc.CraftIRC;
import com.ensifera.animosity.craftirc.DualKey;
import com.ensifera.animosity.craftirc.EndPoint;
import com.ensifera.animosity.craftirc.RelayedMessageException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RelayedMessage {
    private CraftIRC plugin;
    private EndPoint source;
    private EndPoint target;
    public String formatting;
    public String sender;
    public String message;
    public String moderator;
    public String srcChannel;
    public int srcBot;
    public String trgChannel;
    public int trgBot;
    public String srcChannelTag;
    public String world;

    protected RelayedMessage(CraftIRC plugin, EndPoint source, EndPoint target) {
        this.plugin = plugin;
        this.formatting = null;
        this.setSource(source);
        this.setTarget(target);
        this.sender = "";
        this.message = "";
        this.moderator = "";
        this.srcChannel = "";
        this.trgChannel = "";
        this.srcBot = -1;
        this.trgBot = -1;
        this.srcChannelTag = plugin.chanTagMap.get(new DualKey(this.srcBot, this.srcChannel));
        this.world = "";
    }

    public void updateTag() {
        this.srcChannelTag = this.plugin.chanTagMap.get(new DualKey(this.srcBot, this.srcChannel));
    }

    public CraftIRC getPlugin() {
        return this.plugin;
    }

    public EndPoint getSource() {
        return this.source;
    }

    public EndPoint getTarget() {
        return this.target;
    }

    public void setSource(EndPoint ep) {
        this.source = ep == EndPoint.BOTH ? EndPoint.UNKNOWN : ep;
    }

    public void setTarget(EndPoint ep) {
        this.target = ep;
    }

    public String asString() throws RelayedMessageException {
        if (this.target != EndPoint.BOTH) {
            return this.asString(this.target);
        }
        return this.asString(EndPoint.UNKNOWN);
    }

    public String asString(EndPoint realTarget) throws RelayedMessageException {
        String result = "";
        String msgout = this.message;
        int formattingBot = this.trgBot;
        String formattingChannel = this.trgChannel;
        if (this.source == EndPoint.PLUGIN || this.target == EndPoint.PLUGIN || this.target == EndPoint.UNKNOWN) {
            result = this.message;
        }
        if (this.source == EndPoint.GAME && this.target == EndPoint.IRC) {
            result = this.plugin.cFormatting("game-to-irc." + this.formatting, this.trgBot, this.trgChannel);
        }
        if (this.source == EndPoint.IRC && (this.target == EndPoint.IRC || this.target == EndPoint.BOTH && realTarget == EndPoint.IRC)) {
            result = this.plugin.cFormatting("irc-to-irc." + this.formatting, this.trgBot, this.trgChannel);
        }
        if (this.source == EndPoint.IRC && (this.target == EndPoint.GAME || this.target == EndPoint.BOTH && realTarget == EndPoint.GAME)) {
            if (this.plugin.cChanChatColors(this.srcBot, this.srcChannel)) {
                msgout = msgout.replaceAll("(" + Character.toString('\u0002') + "|" + Character.toString('\u0016') + "|" + Character.toString('\u001f') + ")", "");
                Pattern color_codes = Pattern.compile(Character.toString('\u0003') + "([01]?[0-9])(,[0-9]{0,2})?");
                Matcher find_colors = color_codes.matcher(msgout);
                while (find_colors.find()) {
                    msgout = find_colors.replaceFirst(this.plugin.cColorGameFromIrc(Integer.parseInt(find_colors.group(1))));
                    find_colors = color_codes.matcher(msgout);
                }
                msgout = msgout.replaceAll(Character.toString('\u000f') + "|" + Character.toString('\u0003'), this.plugin.cColorGameFromName("foreground"));
            } else {
                msgout = msgout.replaceAll("(" + Character.toString('\u0002') + "|" + Character.toString('\u000f') + "|" + Character.toString('\u0016') + Character.toString('\u001f') + "|" + Character.toString('\u0003') + "[0-9]{0,2}(,[0-9]{0,2})?)", "");
            }
            msgout = msgout + " ";
            formattingBot = this.srcBot;
            formattingChannel = this.srcChannel;
            result = this.plugin.cFormatting("irc-to-game." + this.formatting, this.srcBot, this.srcChannel);
        }
        if (result == null) {
            throw new RelayedMessageException(this);
        }
        result = result.replaceAll("%k([0-9]{1,2})%", Character.toString('\u0003') + "$1");
        result = result.replaceAll("%k([0-9]{1,2}),([0-9]{1,2})%", Character.toString('\u0003') + "$1,$2");
        result = result.replace("%k%", Character.toString('\u0003'));
        result = result.replace("%o%", Character.toString('\u000f'));
        result = result.replace("%b%", Character.toString('\u0002'));
        result = result.replace("%u%", Character.toString('\u001f'));
        result = result.replace("%r%", Character.toString('\u0016'));
        result = result.replace("%sender%", this.sender);
        result = result.replace("%message%", msgout);
        result = result.replace("%moderator%", this.moderator);
        result = result.replace("%srcChannel%", this.srcChannel);
        result = result.replace("%trgChannel%", this.trgChannel);
        result = result.replace("%world%", this.world);
        if (this.source == EndPoint.GAME && this.plugin.hasPerms() && this.plugin.cChanNameColors(this.trgBot, this.trgChannel)) {
            result = result.replace("%prefix%", this.plugin.getPermPrefix(this.world, this.sender));
            result = result.replace("%suffix%", this.plugin.getPermSuffix(this.world, this.sender));
            if (!this.moderator.equals("")) {
                result = result.replace("%modPrefix%", this.plugin.getPermPrefix(this.world, this.moderator));
                result = result.replace("%modSuffix%", this.plugin.getPermSuffix(this.world, this.moderator));
            } else {
                result = result.replace("%modPrefix%", "");
                result = result.replace("%modSuffix%", "");
            }
        } else {
            result = result.replace("%prefix%", "");
            result = result.replace("%suffix%", "");
            result = result.replace("%modPrefix%", "");
            result = result.replace("%modSuffix%", "");
        }
        Pattern other_vars = Pattern.compile("%([A-Za-z0-9]+)%");
        Matcher find_vars = other_vars.matcher(result);
        while (find_vars.find()) {
            String aux = this.plugin.cFormatting("custom." + find_vars.group(1), formattingBot, formattingChannel);
            if (aux != null) {
                result = find_vars.replaceFirst(aux);
            } else if (this.target == EndPoint.IRC || this.target == EndPoint.BOTH && realTarget == EndPoint.IRC) {
                result = find_vars.replaceFirst(Character.toString('\u0003') + String.format("%02d", this.plugin.cColorIrcFromName(find_vars.group(1))));
            } else if (this.target == EndPoint.GAME || this.target == EndPoint.BOTH && realTarget == EndPoint.GAME) {
                result = find_vars.replaceFirst(this.plugin.cColorGameFromName(find_vars.group(1)));
            }
            find_vars = other_vars.matcher(result);
        }
        return result;
    }
}

