/*
 * Decompiled with CFR 0.152.
 */
package com.ensifera.animosity.craftirc;

import com.ensifera.animosity.craftirc.CraftIRC;
import com.ensifera.animosity.craftirc.EndPoint;
import com.ensifera.animosity.craftirc.IRCConsoleCommandSender;
import com.ensifera.animosity.craftirc.IRCEvent;
import com.ensifera.animosity.craftirc.RelayedMessage;
import com.ensifera.animosity.craftirc.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jibble.pircbot.IrcException;
import org.jibble.pircbot.PircBot;
import org.jibble.pircbot.TrustingSSLSocketFactory;
import org.jibble.pircbot.User;

public class Minebot
extends PircBot
implements Runnable {
    private CraftIRC plugin = null;
    private int botId;
    private String nickname;
    private boolean ssl;
    private String ircServer;
    private int ircPort;
    private String ircPass;
    private String authMethod;
    private String authUser;
    private String authPass;
    private ArrayList<String> channels;
    private ArrayList<String> ignores;
    private String cmdPrefix;
    private ArrayList<String> ircCmdPrefixes;

    protected Minebot(CraftIRC plugin, int botId) {
        this.plugin = plugin;
        this.botId = botId;
    }

    public synchronized Minebot init(boolean debug) {
        this.setVerbose(debug);
        this.setMessageDelay(this.plugin.cBotMessageDelay(this.botId));
        this.setName(this.plugin.cBotNickname(this.botId));
        this.setFinger("CraftIRC v" + CraftIRC.VERSION);
        this.setLogin(this.plugin.cBotLogin(this.botId));
        this.setVersion("CraftIRC v" + CraftIRC.VERSION);
        this.nickname = this.plugin.cBotNickname(this.botId);
        this.ssl = this.plugin.cBotSsl(this.botId);
        this.ircServer = this.plugin.cBotServer(this.botId);
        this.ircPort = this.plugin.cBotPort(this.botId);
        this.ircPass = this.plugin.cBotPassword(this.botId);
        this.authMethod = this.plugin.cBotAuthMethod(this.botId);
        this.authUser = this.plugin.cBotAuthUsername(this.botId);
        this.authPass = this.plugin.cBotAuthPassword(this.botId);
        this.channels = this.plugin.cBotChannels(this.botId);
        this.ignores = this.plugin.cBotIgnoredUsers(this.botId);
        this.cmdPrefix = this.plugin.cCommandPrefix(this.botId);
        this.ircCmdPrefixes = this.plugin.cIgnoredPrefixes("irc");
        try {
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public void start() {
        CraftIRC.log.info("CraftIRC v" + CraftIRC.VERSION + " loading.");
        try {
            this.setAutoNickChange(true);
            String localAddr = this.plugin.cBindLocalAddr();
            if (!localAddr.isEmpty() && this.bindLocalAddr(localAddr, this.ircPort)) {
                CraftIRC.log.info("CraftIRC - BINDING socket to " + localAddr + ":" + this.ircPort);
            }
            if (this.ssl) {
                CraftIRC.log.info("CraftIRC - Connecting to " + this.ircServer + ":" + this.ircPort + " [SSL]");
                this.connect(this.ircServer, this.ircPort, this.ircPass, new TrustingSSLSocketFactory());
            } else {
                CraftIRC.log.info("CraftIRC - Connecting to " + this.ircServer + ":" + this.ircPort);
                this.connect(this.ircServer, this.ircPort, this.ircPass);
            }
            if (this.isConnected()) {
                CraftIRC.log.info("CraftIRC - Connected");
            } else {
                CraftIRC.log.info("CraftIRC - Connection failed!");
            }
            this.authenticateBot();
            ArrayList<String> onConnect = this.plugin.cBotOnConnect(this.botId);
            Iterator<String> it = onConnect.iterator();
            while (it.hasNext()) {
                this.sendRawLineViaQueue(it.next());
            }
            for (String chan : this.channels) {
                this.joinChannel(chan, this.plugin.cChanPassword(this.botId, chan));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IrcException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CraftIRC getPlugin() {
        return this.plugin;
    }

    void authenticateBot() {
        if (this.authMethod.equalsIgnoreCase("nickserv") && !this.authPass.isEmpty()) {
            CraftIRC.log.info("CraftIRC - Using Nickserv authentication.");
            this.sendMessage("nickserv", "GHOST " + this.nickname + " " + this.authPass);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.changeNick(this.nickname);
            this.identify(this.authPass);
        } else if (this.authMethod.equalsIgnoreCase("gamesurge")) {
            CraftIRC.log.info("CraftIRC - Using GameSurge authentication.");
            this.changeNick(this.nickname);
            this.sendMessage("AuthServ@Services.GameSurge.net", "AUTH " + this.authUser + " " + this.authPass);
        } else if (this.authMethod.equalsIgnoreCase("quakenet")) {
            CraftIRC.log.info("CraftIRC - Using QuakeNet authentication.");
            this.changeNick(this.nickname);
            this.sendMessage("Q@CServe.quakenet.org", "AUTH " + this.authUser + " " + this.authPass);
        }
    }

    @Override
    public void onJoin(String channel, String sender, String login, String hostname) {
        if (this.plugin.isDebug()) {
            CraftIRC.log.info(String.format("CraftIRC Minebot IRCEVENT.JOIN", new Object[0]));
        }
        if (this.channels.contains(channel)) {
            if (sender.equals(this.nickname)) {
                CraftIRC.log.info("CraftIRC - Joined channel: " + channel);
                ArrayList<String> onJoin = this.plugin.cChanOnJoin(this.botId, channel);
                Iterator<String> it = onJoin.iterator();
                while (it.hasNext()) {
                    this.sendRawLineViaQueue(it.next());
                }
            } else {
                RelayedMessage msg = this.plugin.newMsg(EndPoint.IRC, EndPoint.BOTH);
                msg.formatting = "joins";
                msg.sender = sender;
                msg.srcBot = this.botId;
                msg.srcChannel = channel;
                msg.updateTag();
                this.plugin.sendMessage(msg, null, "joins");
                msg.setTarget(EndPoint.PLUGIN);
                IRCEvent ie = new IRCEvent(IRCEvent.Mode.JOIN, msg);
                this.plugin.getServer().getPluginManager().callEvent((Event)ie);
            }
        }
    }

    @Override
    public void onPart(String channel, String sender, String login, String hostname, String reason) {
        if (this.plugin.isDebug()) {
            CraftIRC.log.info(String.format("CraftIRC Minebot IRCEVENT.PART", new Object[0]));
        }
        if (this.channels.contains(channel)) {
            RelayedMessage msg = this.plugin.newMsg(EndPoint.IRC, EndPoint.BOTH);
            msg.formatting = "parts";
            msg.sender = sender;
            msg.srcBot = this.botId;
            msg.srcChannel = channel;
            msg.message = reason;
            msg.updateTag();
            this.plugin.sendMessage(msg, null, "parts");
            msg.setTarget(EndPoint.PLUGIN);
            IRCEvent ie = new IRCEvent(IRCEvent.Mode.PART, msg);
            this.plugin.getServer().getPluginManager().callEvent((Event)ie);
        }
    }

    @Override
    public void onChannelQuit(String channel, String sender, String login, String hostname, String reason) {
        if (this.plugin.isDebug()) {
            CraftIRC.log.info(String.format("CraftIRC Minebot IRCEVENT.QUIT", new Object[0]));
        }
        if (this.channels.contains(channel)) {
            RelayedMessage msg = this.plugin.newMsg(EndPoint.IRC, EndPoint.BOTH);
            msg.formatting = "quits";
            msg.sender = sender;
            msg.srcBot = this.botId;
            msg.srcChannel = channel;
            msg.message = reason;
            msg.updateTag();
            this.plugin.sendMessage(msg, null, "quits");
            msg.setTarget(EndPoint.PLUGIN);
            IRCEvent ie = new IRCEvent(IRCEvent.Mode.QUIT, msg);
            this.plugin.getServer().getPluginManager().callEvent((Event)ie);
        }
    }

    @Override
    public void onKick(String channel, String kickerNick, String kickerLogin, String kickerHostname, String recipientNick, String reason) {
        if (recipientNick.equalsIgnoreCase(this.getNick()) && this.channels.contains(channel)) {
            this.joinChannel(channel, this.plugin.cChanPassword(this.botId, channel));
        }
        RelayedMessage msg = this.plugin.newMsg(EndPoint.IRC, EndPoint.BOTH);
        msg.formatting = "kicks";
        msg.sender = recipientNick;
        msg.srcBot = this.botId;
        msg.srcChannel = channel;
        msg.message = reason;
        msg.moderator = kickerNick;
        msg.updateTag();
        this.plugin.sendMessage(msg, null, "kicks");
        if (this.plugin.isDebug()) {
            CraftIRC.log.info(String.format("CraftIRC Minebot IRCEVENT.KICK", new Object[0]));
        }
        msg.setTarget(EndPoint.PLUGIN);
        IRCEvent ie = new IRCEvent(IRCEvent.Mode.KICK, msg);
        this.plugin.getServer().getPluginManager().callEvent((Event)ie);
    }

    @Override
    public void onChannelNickChange(String channel, String oldNick, String login, String hostname, String newNick) {
        RelayedMessage msg = this.plugin.newMsg(EndPoint.IRC, EndPoint.BOTH);
        msg.formatting = "nicks";
        msg.sender = oldNick;
        msg.srcBot = this.botId;
        msg.srcChannel = channel;
        msg.message = newNick;
        msg.updateTag();
        this.plugin.sendMessage(msg, null, "nicks");
        if (this.plugin.isDebug()) {
            CraftIRC.log.info(String.format("CraftIRC Minebot IRCEVENT.NICKCHANGE", new Object[0]));
        }
        msg.setTarget(EndPoint.PLUGIN);
        IRCEvent ie = new IRCEvent(IRCEvent.Mode.NICKCHANGE, msg);
        this.plugin.getServer().getPluginManager().callEvent((Event)ie);
    }

    @Override
    public void onMessage(String channel, String sender, String login, String hostname, String message) {
        if (this.plugin.isDebug()) {
            CraftIRC.log.info(String.format("CraftIRC Minebot onMessage", new Object[0]));
        }
        if (this.ignores.contains(sender)) {
            return;
        }
        try {
            IRCEvent ie;
            RelayedMessage msg;
            String[] splitMessage = message.split(" ");
            String command = Util.combineSplit(1, splitMessage, " ");
            if (message.startsWith(this.cmdPrefix) && this.userAuthorized(channel, sender) && !this.ircCmdPrefixes.contains(message.substring(0, 0))) {
                if (this.plugin.isDebug()) {
                    CraftIRC.log.info(String.format("CraftIRC Authorized User %s used command %s", sender, message));
                }
                if ((message.startsWith(this.cmdPrefix + "cmd ") || message.startsWith(this.cmdPrefix + "c ")) && splitMessage.length > 1) {
                    RelayedMessage ircConCmd = this.plugin.newMsg(EndPoint.IRC, EndPoint.UNKNOWN);
                    ircConCmd.formatting = "";
                    ircConCmd.sender = sender;
                    ircConCmd.srcBot = this.botId;
                    ircConCmd.srcChannel = channel;
                    ircConCmd.message = message.replaceFirst(this.cmdPrefix, "");
                    ircConCmd.updateTag();
                    if (this.routeCommand(command, ircConCmd)) {
                        this.sendNotice(sender, "Executed console command: " + command);
                        if (this.plugin.isDebug()) {
                            CraftIRC.log.info(String.format("CraftIRC Authorized User %s executed command %s", sender, message));
                        }
                        return;
                    }
                } else {
                    if (message.startsWith(this.cmdPrefix + "botsay ") && splitMessage.length > 1) {
                        if (this.channels.contains(splitMessage[1])) {
                            command = Util.combineSplit(2, splitMessage, " ");
                            this.sendMessage(splitMessage[1], command);
                            this.sendNotice(sender, "Sent to channel " + splitMessage[1] + ": " + command);
                        } else {
                            Iterator<String> it = this.channels.iterator();
                            while (it.hasNext()) {
                                this.sendMessage(it.next(), command);
                            }
                            this.sendNotice(sender, "Sent to all channels: " + command);
                        }
                        return;
                    }
                    if (message.startsWith(this.cmdPrefix + "raw ") && splitMessage.length > 1) {
                        this.sendRawLine(command);
                        this.sendNotice(sender, "Raw IRC string sent");
                        return;
                    }
                }
                if (this.plugin.isDebug()) {
                    CraftIRC.log.info(String.format("CraftIRC Minebot IRCEVENT.AUTHED_COMMAND", new Object[0]));
                }
                msg = this.plugin.newMsg(EndPoint.IRC, EndPoint.BOTH);
                msg.formatting = "";
                msg.sender = sender;
                msg.srcBot = this.botId;
                msg.srcChannel = channel;
                msg.message = message.replaceFirst(this.cmdPrefix, "");
                msg.updateTag();
                msg.setTarget(EndPoint.PLUGIN);
                ie = new IRCEvent(IRCEvent.Mode.AUTHED_COMMAND, msg);
                this.plugin.getServer().getPluginManager().callEvent((Event)ie);
                if (ie.isHandled()) {
                    return;
                }
            }
            if (!this.ircCmdPrefixes.contains(message.substring(0, 0)) && !message.startsWith(this.cmdPrefix)) {
                if (this.plugin.isDebug()) {
                    CraftIRC.log.info(String.format("CraftIRC Minebot allchat", new Object[0]));
                }
                msg = this.plugin.newMsg(EndPoint.IRC, EndPoint.BOTH);
                msg.formatting = "chat";
                msg.sender = sender;
                msg.srcBot = this.botId;
                msg.srcChannel = channel;
                msg.message = message;
                msg.updateTag();
                this.plugin.sendMessage(msg, null, "all-chat");
                if (this.plugin.isDebug()) {
                    CraftIRC.log.info(String.format("CraftIRC Minebot IRCEVENT.MSG", new Object[0]));
                }
                msg.setTarget(EndPoint.PLUGIN);
                ie = new IRCEvent(IRCEvent.Mode.MSG, msg);
                this.plugin.getServer().getPluginManager().callEvent((Event)ie);
                return;
            }
            if (message.startsWith(this.cmdPrefix + "say ") || message.startsWith(this.cmdPrefix + "mc ")) {
                if (splitMessage.length > 1) {
                    msg = this.plugin.newMsg(EndPoint.IRC, EndPoint.GAME);
                    msg.formatting = "chat";
                    msg.sender = sender;
                    msg.srcBot = this.botId;
                    msg.srcChannel = channel;
                    msg.message = command;
                    msg.updateTag();
                    this.plugin.sendMessage(msg, null, null);
                    this.sendNotice(sender, "Message sent to game");
                    return;
                }
            } else {
                if (message.startsWith(this.cmdPrefix + "players")) {
                    if (this.plugin.isDebug()) {
                        CraftIRC.log.info(String.format("CraftIRC Minebot .players command", new Object[0]));
                    }
                    String playerListing = this.getPlayerList();
                    this.sendMessage(channel, playerListing);
                    return;
                }
                if (this.plugin.isDebug()) {
                    CraftIRC.log.info(String.format("CraftIRC Minebot IRCEVENT.COMMAND", new Object[0]));
                }
                msg = this.plugin.newMsg(EndPoint.IRC, EndPoint.BOTH);
                msg.formatting = "";
                msg.sender = sender;
                msg.srcBot = this.botId;
                msg.srcChannel = channel;
                msg.message = message.replaceFirst(this.cmdPrefix, "");
                msg.updateTag();
                msg.setTarget(EndPoint.PLUGIN);
                ie = new IRCEvent(IRCEvent.Mode.COMMAND, msg);
                this.plugin.getServer().getPluginManager().callEvent((Event)ie);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CraftIRC.log.log(Level.SEVERE, "CraftIRC - error while relaying IRC command: " + message);
        }
    }

    @Override
    protected void onPrivateMessage(String sender, String login, String hostname, String message) {
        if (this.plugin.isDebug()) {
            CraftIRC.log.info(String.format("CraftIRC Minebot IRCEVENT.PRIVMSG", new Object[0]));
        }
        if (this.ignores.contains(sender)) {
            return;
        }
        String[] splitMessage = message.split(" ");
        try {
            if (splitMessage.length > 1 && splitMessage[0].equalsIgnoreCase("tell")) {
                if (this.plugin.getServer().getPlayer(splitMessage[1]) != null) {
                    this.msgToGame(null, sender, Util.combineSplit(2, splitMessage, " "), messageMode.MSG_PLAYER, splitMessage[1]);
                    this.sendNotice(sender, "Whispered to " + splitMessage[1]);
                }
            } else {
                RelayedMessage msg = this.plugin.newMsg(EndPoint.IRC, EndPoint.BOTH);
                msg.formatting = "quits";
                msg.sender = sender;
                msg.srcBot = this.botId;
                msg.srcChannel = "";
                msg.message = message;
                msg.updateTag();
                msg.setTarget(EndPoint.PLUGIN);
                IRCEvent ie = new IRCEvent(IRCEvent.Mode.PRIVMSG, msg);
                this.plugin.getServer().getPluginManager().callEvent((Event)ie);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void onAction(String sender, String login, String hostname, String target, String action) {
        if (this.plugin.isDebug()) {
            CraftIRC.log.info(String.format("CraftIRC Minebot IRCEVENT.ACTION", new Object[0]));
        }
        RelayedMessage msg = this.plugin.newMsg(EndPoint.IRC, EndPoint.BOTH);
        msg.formatting = "action";
        msg.sender = sender;
        msg.srcBot = this.botId;
        msg.srcChannel = target;
        msg.message = action;
        msg.updateTag();
        this.plugin.sendMessage(msg, null, "all-chat");
        msg.setTarget(EndPoint.PLUGIN);
        IRCEvent ie = new IRCEvent(IRCEvent.Mode.ACTION, msg);
        this.plugin.getServer().getPluginManager().callEvent((Event)ie);
    }

    public boolean userAuthorized(String channel, String user) {
        if (this.plugin.cChanAdmin(this.botId, channel)) {
            try {
                User check = this.getUser(user, channel);
                if (this.plugin.isDebug()) {
                    CraftIRC.log.info(String.format("CraftIRC Minebot userAuthorized(): " + String.valueOf(check != null && this.plugin.cBotAdminPrefixes(this.botId).contains(this.getHighestUserPrefix(check))), new Object[0]));
                }
                return check != null && this.plugin.cBotAdminPrefixes(this.botId).contains(this.getHighestUserPrefix(check));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean routeCommand(String fullCommand, RelayedMessage ircConCmd) {
        String rootCommand = fullCommand.split(" ")[0];
        if (!this.plugin.cConsoleCommands().contains(rootCommand)) {
            if (this.plugin.isDebug()) {
                CraftIRC.log.info(String.format("CraftIRC Console command: %s not found in config.yml", rootCommand));
            }
            return false;
        }
        if (CraftIRC.defaultConsoleCommands.contains(rootCommand)) {
            if (this.plugin.isDebug()) {
                CraftIRC.log.info(String.format("CraftIRC Minebot routeCommand(default) fullCommand=" + fullCommand + " -- rootCommand=" + rootCommand, new Object[0]));
                CraftIRC.log.info(String.format("CraftIRC Minebot routeCommand(default) -> queueConsoleCommand()", new Object[0]));
            }
            this.plugin.enqueueConsoleCommand(fullCommand);
        } else {
            IRCConsoleCommandSender console;
            if (this.plugin.isDebug()) {
                CraftIRC.log.info(String.format("CraftIRC Minebot routeCommand() fullCommand=" + fullCommand + " -- rootCommand=" + rootCommand, new Object[0]));
                CraftIRC.log.info(String.format("CraftIRC Minebot routeCommand() -> Bukkit dispatchCommand()", new Object[0]));
            }
            if (((CraftServer)this.plugin.server).dispatchCommand((CommandSender)(console = new IRCConsoleCommandSender(this.plugin.server, ircConCmd, true)), fullCommand)) {
                return true;
            }
        }
        return false;
    }

    public void msgToGame(String source, String sender, String message, messageMode mm, String target) {
        try {
            switch (mm) {
                case MSG_PLAYER: {
                    if (this.plugin.isDebug()) {
                        CraftIRC.log.info(String.format("CraftIRC msgToGame(player) : <%s> %s", sender, message));
                    }
                    String msg_to_broadcast = "[IRC privmsg]" + " <" + sender + ChatColor.WHITE + "> " + message;
                    Player p = this.plugin.getServer().getPlayer(target);
                    if (p == null) break;
                    p.sendMessage(msg_to_broadcast);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getPlayerList() {
        try {
            Player[] onlinePlayers = this.plugin.getServer().getOnlinePlayers();
            int playerCount = 0;
            int maxPlayers = this.plugin.getServer().getMaxPlayers();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < onlinePlayers.length; ++i) {
                if (onlinePlayers[i] == null) continue;
                ++playerCount;
                sb.append(" ").append(onlinePlayers[i].getName());
            }
            if (playerCount > 0) {
                return "Online (" + playerCount + "/" + maxPlayers + "): " + sb.toString();
            }
            return "Nobody is minecrafting right now.";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Could not retrieve player list!";
        }
    }

    public ArrayList<String> getChannelList() {
        try {
            return new ArrayList<String>(Arrays.asList(this.getChannels()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void onDisconnect() {
        try {
            if (this.plugin.isEnabled()) {
                CraftIRC.log.info("CraftIRC - disconnected from IRC server... reconnecting!");
                while (!this.isConnected()) {
                    this.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void msg(String target, String message) {
        if (this.plugin.isDebug()) {
            CraftIRC.log.info(String.format("CraftIRC msgToIRC <%s> : %s", target, message));
        }
        this.sendMessage(target, message);
    }

    @Override
    public void run() {
        this.init(false);
    }

    private static enum messageMode {
        MSG_ALL,
        ACTION_ALL,
        MSG_PLAYER,
        IRC_JOIN,
        IRC_QUIT,
        IRC_PART;

    }
}

