/*
 * Decompiled with CFR 0.152.
 */
package com.ensifera.animosity.craftirc;

import com.ensifera.animosity.craftirc.CraftIRCListener;
import com.ensifera.animosity.craftirc.DualKey;
import com.ensifera.animosity.craftirc.EndPoint;
import com.ensifera.animosity.craftirc.IRCConsoleCommandSender;
import com.ensifera.animosity.craftirc.Minebot;
import com.ensifera.animosity.craftirc.RelayedMessage;
import com.ensifera.animosity.craftirc.RelayedMessageException;
import com.ensifera.animosity.craftirc.Util;
import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.MinecraftServer;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.config.Configuration;
import org.bukkit.util.config.ConfigurationNode;

public class CraftIRC
extends JavaPlugin {
    public static final String NAME = "CraftIRC";
    public static String VERSION;
    protected static final Logger log;
    public static List<String> defaultConsoleCommands;
    PluginDescriptionFile desc = null;
    public Server server = null;
    private MinecraftServer console;
    private final CraftIRCListener listener = new CraftIRCListener(this);
    private PermissionHandler perms = null;
    private ArrayList<Minebot> instances;
    private boolean debug;
    private Timer holdTimer = new Timer();
    protected HashMap<HoldType, Boolean> hold;
    private ArrayList<ConfigurationNode> bots = new ArrayList();
    private ArrayList<ConfigurationNode> colormap = new ArrayList();
    private HashMap<Integer, ArrayList<ConfigurationNode>> channodes;
    private HashMap<Integer, ArrayList<String>> channames;
    protected HashMap<DualKey, String> chanTagMap;

    public void onEnable() {
        try {
            Plugin check;
            PluginDescriptionFile desc = this.getDescription();
            VERSION = desc.getVersion();
            this.server = this.getServer();
            Field cfield = CraftServer.class.getDeclaredField("console");
            cfield.setAccessible(true);
            this.console = (MinecraftServer)cfield.get((CraftServer)this.getServer());
            if (null == this.getConfiguration()) {
                log.info(String.format("CraftIRC config.yml could not be found in plugins/CraftIRC/ -- disabling!", new Object[0]));
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            this.bots = new ArrayList(this.getConfiguration().getNodeList("bots", null));
            this.colormap = new ArrayList(this.getConfiguration().getNodeList("colormap", null));
            this.channodes = new HashMap();
            this.channames = new HashMap();
            this.chanTagMap = new HashMap();
            for (int botID = 0; botID < this.bots.size(); ++botID) {
                this.channodes.put(botID, new ArrayList(this.bots.get(botID).getNodeList("channels", null)));
                ArrayList<String> cn = new ArrayList<String>();
                Iterator<ConfigurationNode> it = this.channodes.get(botID).iterator();
                while (it.hasNext()) {
                    String channelName = it.next().getString("name");
                    this.chanTagMap.put(new DualKey(botID, channelName), this.cChanTag(botID, channelName));
                    cn.add(channelName);
                }
                this.channames.put(botID, cn);
            }
            if (this.isDebug()) {
                log.info(String.format("CraftIRC Channel tag map: " + this.chanTagMap.toString(), new Object[0]));
            }
            if ((check = this.getServer().getPluginManager().getPlugin("Permissions")) != null) {
                this.perms = ((Permissions)check).getHandler();
                log.info("Permissions detected by CraftIRC.");
            } else {
                log.info("Permissions not detected.");
            }
            this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_COMMAND_PREPROCESS, (Listener)this.listener, Event.Priority.Monitor, (Plugin)this);
            this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_JOIN, (Listener)this.listener, Event.Priority.Monitor, (Plugin)this);
            this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_QUIT, (Listener)this.listener, Event.Priority.Monitor, (Plugin)this);
            this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_CHAT, (Listener)this.listener, Event.Priority.Monitor, (Plugin)this);
            this.instances = new ArrayList();
            for (int i = 0; i < this.bots.size(); ++i) {
                this.instances.add(new Minebot(this, i).init(this.cDebug()));
            }
            log.info("CraftIRC Enabled.");
            this.hold = new HashMap();
            this.holdTimer = new Timer();
            Date now = new Date();
            if (this.cHold("chat") > 0) {
                this.hold.put(HoldType.CHAT, true);
                this.holdTimer.schedule((TimerTask)new RemoveHoldTask(this, HoldType.CHAT), this.cHold("chat"));
            } else {
                this.hold.put(HoldType.CHAT, false);
            }
            if (this.cHold("joins") > 0) {
                this.hold.put(HoldType.JOINS, true);
                this.holdTimer.schedule((TimerTask)new RemoveHoldTask(this, HoldType.JOINS), this.cHold("joins"));
            } else {
                this.hold.put(HoldType.JOINS, false);
            }
            if (this.cHold("quits") > 0) {
                this.hold.put(HoldType.QUITS, true);
                this.holdTimer.schedule((TimerTask)new RemoveHoldTask(this, HoldType.QUITS), this.cHold("quits"));
            } else {
                this.hold.put(HoldType.QUITS, false);
            }
            if (this.cHold("kicks") > 0) {
                this.hold.put(HoldType.KICKS, true);
                this.holdTimer.schedule((TimerTask)new RemoveHoldTask(this, HoldType.KICKS), this.cHold("kicks"));
            } else {
                this.hold.put(HoldType.KICKS, false);
            }
            if (this.cHold("bans") > 0) {
                this.hold.put(HoldType.BANS, true);
                this.holdTimer.schedule((TimerTask)new RemoveHoldTask(this, HoldType.BANS), this.cHold("bans"));
            } else {
                this.hold.put(HoldType.BANS, false);
            }
            this.setDebug(this.cDebug());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        try {
            this.holdTimer.cancel();
            for (int i = 0; i < this.bots.size(); ++i) {
                this.instances.get(i).disconnect();
            }
            log.info("CraftIRC Disabled.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        block18: {
            String commandName = command.getName().toLowerCase();
            try {
                if (sender instanceof IRCConsoleCommandSender) {
                    sender = (IRCConsoleCommandSender)((Object)sender);
                }
                if (commandName.equals("irc")) {
                    if (this.isDebug()) {
                        log.info(String.format("CraftIRC CraftIRCListener onCommand(): commandName=irc " + args.toString(), new Object[0]));
                    }
                    if (sender instanceof Player && this.checkPerms((Player)sender, "craftirc.irc") || sender instanceof IRCConsoleCommandSender) {
                        return this.cmdMsgToAll((CommandSender)sender, args);
                    }
                    break block18;
                }
                if (commandName.equals("ircm")) {
                    if (this.isDebug()) {
                        log.info(String.format("CraftIRC CraftIRCListener onCommand(): commandName=ircm", new Object[0]));
                    }
                    if (sender instanceof Player && this.checkPerms((Player)sender, "craftirc.ircm") || sender instanceof IRCConsoleCommandSender) {
                        return this.cmdMsgToTag((CommandSender)sender, args);
                    }
                    break block18;
                }
                if (commandName.equals("ircwho")) {
                    if (this.isDebug()) {
                        log.info(String.format("CraftIRC CraftIRCListener onCommand(): commandName=ircwho", new Object[0]));
                    }
                    if (sender instanceof Player && this.checkPerms((Player)sender, "craftirc.ircwho") || sender instanceof IRCConsoleCommandSender) {
                        return this.cmdGetIrcUserList((CommandSender)sender, args);
                    }
                    break block18;
                }
                if (commandName.equals("admins!")) {
                    if (this.isDebug()) {
                        log.info(String.format("CraftIRC CraftIRCListener onCommand(): commandName=admins!", new Object[0]));
                    }
                    if (sender instanceof Player && this.checkPerms((Player)sender, "craftirc.admins!") || sender instanceof IRCConsoleCommandSender) {
                        return this.cmdNotifyIrcAdmins((CommandSender)sender, args);
                    }
                    break block18;
                }
                if (commandName.equals("ircraw")) {
                    if (this.isDebug()) {
                        log.info(String.format("CraftIRC CraftIRCListener onCommand(): commandName=ircraw", new Object[0]));
                    }
                    if (sender instanceof Player && this.checkPerms((Player)sender, "craftirc.ircraw") || sender instanceof IRCConsoleCommandSender) {
                        return this.cmdRawIrcCommand((CommandSender)sender, args);
                    }
                    break block18;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return this.debug;
    }

    private boolean cmdMsgToAll(CommandSender sender, String[] args) {
        try {
            if (this.isDebug()) {
                log.info(String.format("CraftIRC CraftIRCListener cmdMsgToAll()", new Object[0]));
            }
            if (args.length == 0) {
                if (this.isDebug()) {
                    log.info(String.format("CraftIRC CraftIRCListener: args.length == 0", new Object[0]));
                }
                return false;
            }
            String msgToSend = Util.combineSplit(0, args, " ");
            RelayedMessage msg = this.newMsg(EndPoint.GAME, EndPoint.IRC);
            if (sender instanceof Player) {
                if (this.isDebug()) {
                    log.info(String.format("CraftIRC CraftIRCListener: sender is a Player", new Object[0]));
                }
                msg.sender = ((Player)sender).getName();
            } else {
                if (this.isDebug()) {
                    log.info(String.format("CraftIRC CraftIRCListener sender is not a Player", new Object[0]));
                }
                msg.sender = "SERVER";
            }
            msg.formatting = "chat";
            msg.message = msgToSend;
            this.sendMessage(msg, null, null);
            String echoedMessage = "<" + msg.sender + ChatColor.WHITE.toString() + " to IRC> " + msgToSend;
            for (Player p : this.getServer().getOnlinePlayers()) {
                if (p == null) continue;
                p.sendMessage(echoedMessage);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean cmdMsgToTag(CommandSender sender, String[] args) {
        try {
            if (args.length < 2) {
                return false;
            }
            String msgToSend = Util.combineSplit(1, args, " ");
            RelayedMessage msg = this.newMsg(EndPoint.GAME, EndPoint.IRC);
            msg.sender = sender instanceof Player ? ((Player)sender).getName() : "SERVER";
            msg.formatting = "chat";
            msg.message = msgToSend;
            this.sendMessage(msg, args[0], null);
            String echoedMessage = "<" + msg.sender + ChatColor.WHITE.toString() + " to IRC> " + msgToSend;
            for (Player p : this.getServer().getOnlinePlayers()) {
                if (p == null) continue;
                p.sendMessage(echoedMessage);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean cmdGetIrcUserList(CommandSender sender, String[] args) {
        try {
            if (args.length == 0) {
                return false;
            }
            sender.sendMessage("IRC users in " + args[0] + " channel(s):");
            ArrayList<String> userlists = this.ircUserLists(args[0]);
            Iterator<String> it = userlists.iterator();
            while (it.hasNext()) {
                sender.sendMessage(it.next());
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean cmdNotifyIrcAdmins(CommandSender sender, String[] args) {
        try {
            if (this.isDebug()) {
                log.info(String.format("CraftIRC CraftIRCListener cmdNotifyIrcAdmins()", new Object[0]));
            }
            if (args.length == 0 || !(sender instanceof Player)) {
                if (this.isDebug()) {
                    log.info(String.format("CraftIRC CraftIRCListener cmdNotifyIrcAdmins() - args.length == 0 or Sender != player ", new Object[0]));
                }
                return false;
            }
            this.noticeAdmins("[Admin notice from " + ((Player)sender).getName() + "] " + Util.combineSplit(0, args, " "));
            sender.sendMessage("Admin notice sent.");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean cmdRawIrcCommand(CommandSender sender, String[] args) {
        if (this.isDebug()) {
            log.info(String.format("CraftIRC cmdRawIrcCommand(sender=" + sender.toString() + ", args=" + Util.combineSplit(0, args, " "), new Object[0]));
        }
        if (args.length < 2) {
            return false;
        }
        this.sendRawToBot(Util.combineSplit(1, args, " "), Integer.parseInt(args[0]));
        return true;
    }

    protected RelayedMessage newMsg(EndPoint source, EndPoint target) {
        return new RelayedMessage(this, source, target);
    }

    protected void sendMessage(RelayedMessage msg, String tag, String event) {
        try {
            String realEvent = event;
            if (msg.getTarget() == EndPoint.IRC || msg.getTarget() == EndPoint.BOTH) {
                if (msg.getSource() == EndPoint.IRC) {
                    realEvent = "irc-to-irc." + event;
                }
                if (msg.getSource() == EndPoint.GAME) {
                    realEvent = "game-to-irc." + event;
                }
                for (int i = 0; i < this.bots.size(); ++i) {
                    ArrayList<String> chans = this.cBotChannels(i);
                    for (String chan : chans) {
                        if (msg.getSource() == EndPoint.IRC && msg.srcBot == i && msg.srcChannel.equalsIgnoreCase(chan) || tag != null && !this.cChanCheckTag(tag, i, chan) || event != null && !this.cEvents(realEvent, i, chan)) continue;
                        msg.trgBot = i;
                        msg.trgChannel = chan;
                        if (msg.getTarget() == EndPoint.BOTH) {
                            this.instances.get(i).sendMessage(chan, msg.asString(EndPoint.IRC));
                            continue;
                        }
                        this.instances.get(i).sendMessage(chan, msg.asString());
                    }
                }
            }
            if ((msg.getTarget() == EndPoint.GAME || msg.getTarget() == EndPoint.BOTH) && msg.getSource() == EndPoint.IRC) {
                realEvent = "irc-to-game." + event;
                if ((tag == null || this.cChanCheckTag(tag, msg.srcBot, msg.srcChannel)) && (event == null || this.cEvents(realEvent, msg.srcBot, msg.srcChannel))) {
                    for (Player pl : this.getServer().getOnlinePlayers()) {
                        if (pl == null) continue;
                        if (msg.getTarget() == EndPoint.BOTH) {
                            pl.sendMessage(msg.asString(EndPoint.GAME));
                            continue;
                        }
                        pl.sendMessage(msg.asString());
                    }
                }
            }
        }
        catch (RelayedMessageException rme) {
            log.log(Level.SEVERE, rme.toString());
            rme.printStackTrace();
        }
    }

    protected void sendRawToBot(String rawMessage, int bot) {
        if (this.isDebug()) {
            log.info(String.format("CraftIRC sendRawToBot(bot=" + bot + ", message=" + rawMessage, new Object[0]));
        }
        Minebot targetBot = this.instances.get(bot);
        targetBot.sendRawLineViaQueue(rawMessage);
    }

    protected void sendMsgToTargetViaBot(String message, String target, int bot) {
        Minebot targetBot = this.instances.get(bot);
        targetBot.sendMessage(target, message);
    }

    private void sendRawToBotViaTag(String rawMessage, String tag) {
        if (this.isDebug()) {
            log.info(String.format("CraftIRC sendRawToBot(tag=" + tag + ", message=" + rawMessage, new Object[0]));
        }
    }

    public void sendMessageToTag(String message, String tag) {
        RelayedMessage rm = this.newMsg(EndPoint.PLUGIN, EndPoint.IRC);
        rm.message = message;
        this.sendMessage(rm, tag, null);
    }

    private int getBotIdFromTag(String tag) {
        return 0;
    }

    protected ArrayList<String> ircUserLists(String tag) {
        ArrayList<String> result = new ArrayList<String>();
        if (tag == null) {
            return result;
        }
        for (int i = 0; i < this.bots.size(); ++i) {
            ArrayList<String> chans = this.cBotChannels(i);
            for (String chan : chans) {
                if (!this.cChanCheckTag(tag, i, chan)) continue;
                result.add(Util.getIrcUserList(this.instances.get(i), chan));
            }
        }
        return result;
    }

    public ArrayList<String> getIrcUserListFromTag(String tag) {
        return this.ircUserLists(tag);
    }

    protected void noticeAdmins(String message) {
        for (int i = 0; i < this.bots.size(); ++i) {
            ArrayList<String> chans = this.cBotChannels(i);
            for (String chan : chans) {
                if (!this.cChanAdmin(i, chan)) continue;
                this.instances.get(i).sendNotice(chan, message);
            }
        }
    }

    protected void setDebug(boolean d) {
        this.debug = d;
        for (int i = 0; i < this.bots.size(); ++i) {
            this.instances.get(i).setVerbose(d);
        }
        log.info("CraftIRC DEBUG [" + (d ? "ON" : "OFF") + "]");
    }

    protected boolean isDebug() {
        return this.debug;
    }

    private ConfigurationNode getChanNode(int bot, String channel) {
        ArrayList<ConfigurationNode> botChans = this.channodes.get(bot);
        for (ConfigurationNode chan : botChans) {
            if (!chan.getString("name").equalsIgnoreCase(channel)) continue;
            return chan;
        }
        return Configuration.getEmptyNode();
    }

    protected boolean cDebug() {
        return this.getConfiguration().getBoolean("settings.debug", false);
    }

    protected String cAdminsCmd() {
        return this.getConfiguration().getString("settings.admins-cmd", "/admins!");
    }

    protected ArrayList<String> cConsoleCommands() {
        return new ArrayList<String>(this.getConfiguration().getStringList("settings.console-commands", null));
    }

    protected ArrayList<String> cIgnoredPrefixes(String source) {
        return new ArrayList<String>(this.getConfiguration().getStringList("settings.ignored-prefixes." + source, null));
    }

    protected int cHold(String eventType) {
        return this.getConfiguration().getInt("settings.hold-after-enable." + eventType, 0);
    }

    protected String cFormatting(String eventType, int bot, String channel) {
        eventType = eventType.equals("game-to-irc.all-chat") ? "formatting.chat" : eventType;
        ConfigurationNode source = this.getChanNode(bot, channel);
        if (source == null || source.getString("formatting." + eventType) == null) {
            source = this.bots.get(bot);
        }
        String result = source == null || source.getString("formatting." + eventType) == null ? this.getConfiguration().getString("settings.formatting." + eventType, null) : source.getString("formatting." + eventType, null);
        return result;
    }

    protected boolean cEvents(String eventType, int bot, String channel) {
        boolean def;
        ConfigurationNode source = null;
        boolean bl = def = eventType.equalsIgnoreCase("game-to-irc.all-chat") || eventType.equalsIgnoreCase("irc-to-game.all-chat");
        if (channel != null) {
            source = this.getChanNode(bot, channel);
        }
        if ((source == null || source.getProperty("events." + eventType) == null) && bot > -1) {
            source = this.bots.get(bot);
        }
        if (source == null || source.getProperty("events." + eventType) == null) {
            return this.getConfiguration().getBoolean("settings.events." + eventType, def);
        }
        return source.getBoolean("events." + eventType, false);
    }

    protected int cColorIrcFromGame(String game) {
        for (ConfigurationNode color : this.colormap) {
            if (!color.getString("game").equals(game)) continue;
            return color.getInt("irc", this.cColorIrcFromName("foreground"));
        }
        return this.cColorIrcFromName("foreground");
    }

    protected int cColorIrcFromName(String name) {
        for (ConfigurationNode color : this.colormap) {
            if (!color.getString("name").equalsIgnoreCase(name) || color.getProperty("irc") == null) continue;
            return color.getInt("irc", 1);
        }
        if (name.equalsIgnoreCase("foreground")) {
            return 1;
        }
        return this.cColorIrcFromName("foreground");
    }

    protected String cColorGameFromIrc(int irc) {
        for (ConfigurationNode color : this.colormap) {
            if (color.getInt("irc", -1) != irc) continue;
            return color.getString("game", this.cColorGameFromName("foreground"));
        }
        return this.cColorGameFromName("foreground");
    }

    protected String cColorGameFromName(String name) {
        for (ConfigurationNode color : this.colormap) {
            if (!color.getString("name").equalsIgnoreCase(name) || color.getProperty("game") == null) continue;
            return color.getString("game", "\u00a7f");
        }
        if (name.equalsIgnoreCase("foreground")) {
            return "\u00a7f";
        }
        return this.cColorGameFromName("foreground");
    }

    protected String cBindLocalAddr() {
        return this.getConfiguration().getString("settings.bind-address", "");
    }

    protected ArrayList<String> cBotChannels(int bot) {
        return this.channames.get(bot);
    }

    protected String cBotNickname(int bot) {
        return this.bots.get(bot).getString("nickname", "CraftIRCbot");
    }

    protected String cBotServer(int bot) {
        return this.bots.get(bot).getString("server", "irc.esper.net");
    }

    protected int cBotPort(int bot) {
        return this.bots.get(bot).getInt("port", 6667);
    }

    protected String cBotLogin(int bot) {
        return this.bots.get(bot).getString("userident", "");
    }

    protected String cBotPassword(int bot) {
        return this.bots.get(bot).getString("serverpass", "");
    }

    protected boolean cBotSsl(int bot) {
        return this.bots.get(bot).getBoolean("ssl", false);
    }

    protected int cBotTimeout(int bot) {
        return this.bots.get(bot).getInt("timeout", 5000);
    }

    protected int cBotMessageDelay(int bot) {
        return this.bots.get(bot).getInt("message-delay", 1000);
    }

    protected String cCommandPrefix(int bot) {
        return this.bots.get(bot).getString("command-prefix", this.getConfiguration().getString("settings.command-prefix", "."));
    }

    protected ArrayList<String> cBotAdminPrefixes(int bot) {
        return new ArrayList<String>(this.bots.get(bot).getStringList("admin-prefixes", null));
    }

    protected ArrayList<String> cBotIgnoredUsers(int bot) {
        return new ArrayList<String>(this.bots.get(bot).getStringList("ignored-users", null));
    }

    protected String cBotAuthMethod(int bot) {
        return this.bots.get(bot).getString("auth.method", "nickserv");
    }

    protected String cBotAuthUsername(int bot) {
        return this.bots.get(bot).getString("auth.username", "");
    }

    protected String cBotAuthPassword(int bot) {
        return this.bots.get(bot).getString("auth.password", "");
    }

    protected ArrayList<String> cBotOnConnect(int bot) {
        return new ArrayList<String>(this.bots.get(bot).getStringList("on-connect", null));
    }

    protected String cChanName(int bot, String channel) {
        return this.getChanNode(bot, channel).getString("name", "#changeme");
    }

    protected String cChanTag(int bot, String channel) {
        return this.getChanNode(bot, channel).getString("tag", String.valueOf(bot) + "_" + channel);
    }

    protected String cChanPassword(int bot, String channel) {
        return this.getChanNode(bot, channel).getString("password", "");
    }

    protected boolean cChanAdmin(int bot, String channel) {
        return this.getChanNode(bot, channel).getBoolean("admin", false);
    }

    protected ArrayList<String> cChanOnJoin(int bot, String channel) {
        return new ArrayList<String>(this.getChanNode(bot, channel).getStringList("on-join", null));
    }

    protected boolean cChanChatColors(int bot, String channel) {
        return this.getChanNode(bot, channel).getBoolean("chat-colors", true);
    }

    protected boolean cChanNameColors(int bot, String channel) {
        return this.getChanNode(bot, channel).getBoolean("name-colors", true);
    }

    protected boolean cChanCheckTag(String tag, int bot, String channel) {
        if (tag == null || tag.equals("")) {
            return false;
        }
        if (this.getConfiguration().getString("settings.tag", "all").equalsIgnoreCase(tag)) {
            return true;
        }
        if (this.bots.get(bot).getString("tag", "").equalsIgnoreCase(tag)) {
            return true;
        }
        return this.getChanNode(bot, channel).getString("tag", "").equalsIgnoreCase(tag);
    }

    protected boolean isHeld(HoldType ht) {
        return this.hold.get((Object)ht);
    }

    protected boolean hasPerms() {
        return this.perms != null;
    }

    protected boolean checkPerms(Player pl, String path) {
        if (this.perms == null) {
            return true;
        }
        if (pl != null) {
            return this.perms.has(pl, path);
        }
        return false;
    }

    protected boolean checkPerms(String pl, String path) {
        if (this.perms == null) {
            return true;
        }
        Player pit = this.getServer().getPlayer(pl);
        if (pit != null) {
            return this.perms.has(pit, path);
        }
        return false;
    }

    protected String colorizeName(String name) {
        Pattern color_codes = Pattern.compile("\u00a7[0-9a-f]");
        Matcher find_colors = color_codes.matcher(name);
        while (find_colors.find()) {
            name = find_colors.replaceFirst(Character.toString('\u0003') + String.format("%02d", this.cColorIrcFromGame(find_colors.group())));
            find_colors = color_codes.matcher(name);
        }
        return name;
    }

    protected String getPermPrefix(String world, String pl) {
        if (this.perms == null) {
            return "";
        }
        String group = this.perms.getGroup(world, pl);
        if (group == null) {
            return "";
        }
        String result = this.perms.getGroupPrefix(world, group);
        if (result == null) {
            return "";
        }
        return this.colorizeName(result.replaceAll("&([0-9a-f])", "\u00a7$1"));
    }

    protected String getPermSuffix(String world, String pl) {
        if (this.perms == null) {
            return "";
        }
        String group = this.perms.getGroup(world, pl);
        if (group == null) {
            return "";
        }
        String result = this.perms.getGroupSuffix(world, group);
        if (result == null) {
            return "";
        }
        return this.colorizeName(result.replaceAll("&([0-9a-f])", "\u00a7$1"));
    }

    protected void enqueueConsoleCommand(String cmd) {
        try {
            this.console.a(cmd, (ICommandListener)this.console);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        log = Logger.getLogger("Minecraft");
        defaultConsoleCommands = Arrays.asList("kick", "ban", "pardon", "ban-ip", "pardon-ip", "op", "deop", "tp", "give", "tell", "stop", "save-all", "save-off", "save-on", "say");
    }

    protected class RemoveHoldTask
    extends TimerTask {
        private CraftIRC plugin;
        private HoldType ht;

        protected RemoveHoldTask(CraftIRC plugin, HoldType ht) {
            this.plugin = plugin;
            this.ht = ht;
        }

        @Override
        public void run() {
            this.plugin.hold.put(this.ht, false);
        }
    }

    protected static enum HoldType {
        CHAT,
        JOINS,
        QUITS,
        KICKS,
        BANS;

    }
}

